define(['angular', 'app'], function (angular, app) {
	app.constant("FitnessServiceConstants", {
		// DEV NOTE: 'example1' matches key used in sample_constants.js and sample_module.js
		"fitnessActivities": {
			extensions: {
				object: {
					uidKey: '_id',
					dateKey : [{ from: 'startDate' }],
					defaults : {
						type : 'Activity',
						intensity : 'Very Hard',
						activity : 'Cycling',
						notes : null,
				        value :  {
							minutes : 50,
							steps : 50,
							miles : 50
				        }
					}
				},
				dependency: {
					linkTitles: {
						GET: 'fitness',
						POST: 'fitness'
					}
				},
				collection: {
					name: 'fitness-activities',
					objectType: 'FitnessActivities'
				}
			}
		},
		'goalHistory' : {
			extensions: {
				object : {
					uidKey: 'id',
					dateKey : [{from:'startDate'}],
				},
				dependency: {
					linkTitles: {
						GET:'goals'
					}
				},
				collection:{
					name : 'fitness-goals',
					objectType:'FitnessGoals'
				}

			}
		},
	});

    app.constant('FitnessRemindersConstants', {
		'fitness-activity-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-fitness-activity',
					POST : 'reminders',
					PUT: 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Fitness Activity'
				}
			}
		},
		'fitness-goals-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-fitness-goals',
					POST : 'reminders',
					PUT: 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Fitness Goal'
				}
			}
		}
    });
});